<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AgentController;
use App\Http\Controllers\BranchController;
use Illuminate\Support\Facades\Auth;





/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('index');
});

//user
Route::group(['prefix' => 'user'], function () {
    Route::get('/verify_screen', function () {
        return view('verification');
    });
    
    Route::post('/postLogin', [UserController::class, 'postLogin'])->name('user.postLogin');
    Route::post('/verify_otp', [UserController::class, 'verify_otp'])->name('user.verify_otp');
    Route::post('/resend_otp', [UserController::class, 'resend_otp'])->name('user.resend_otp');
 
    
    Route::middleware(['auth:web'])->group(function () {  

        Route::get('/step1_profile',[UserController::class,'step1_view'])->name('user.step1');
        Route::get('/step2_profile',[UserController::class,'step2_view'])->name('user.step2');
        Route::get('/step3_profile',[UserController::class,'step3_view'])->name('user.step3');
        Route::post('/update_step1', [UserController::class, 'update_step1'])->name('user.step1_update');
        Route::post('/update_step2', [UserController::class, 'update_step2'])->name('user.step2_update');

    });

});

//admin
Route::group(['prefix' => 'admin'], function () {
    Route::get('/login', function () {
        return view('admin_login');
    })->name('admin.login'); 
    Route::post('/postLogin', [AdminController::class, 'postLogin']);

    Route::get('/dashboard', function () {
        return 'dashboard';
    });
    
    Route::middleware(['auth:admin','permission:can_view_product,admin'])->group(function () {  
 
        Route::get('/home1', function () {
            dd(Auth::guard('admin')->user()->getPermissionsViaRoles());
        });
    });

});


//agent
Route::group(['prefix' => 'agent'], function () {
    Route::get('/login', function () {
        return view('agent_login');
    })->name('agent.login'); 

    Route::middleware('auth:agent')->group(function () {   
        Route::get('/dashboard', function () {
            return 'dashboard';
        }); 
    });

});

//branch
Route::group(['prefix' => 'branch'], function () {
    Route::get('/login', function () {
        return view('branch_login');
    })->name('branch.login'); 

    Route::middleware('auth:branch')->group(function () {   
        Route::get('/dashboard', function () {
            return 'dashboard';
        }); 
    });

});




